const { app, BrowserWindow, ipcMain, Menu, autoUpdater, dialog } = require('electron');
const path = require('path');
const updateUrl = "http://localhost/pritmi-update/";

// Handle creating/removing shortcuts on Windows when installing/uninstalling.
if (require('electron-squirrel-startup')) { // eslint-disable-line global-require
    app.quit();
}

let gameWindow;

const createWindow = () => {
    gameWindow = new BrowserWindow({
        width: 800,
        height: 600,
        webPreferences: {
            nodeIntegration: true,
            contextIsolation: false
        }
    });

    if (process.platform !== 'darwin') {
        gameWindow.removeMenu();
    } else {
        setMainMenu();
    }

    gameWindow.loadFile(path.join(__dirname, 'index.html'));
    gameWindow.setContentSize(800,600);
    //gameWindow.maximize();
    //gameWindow.setFullScreen(true);
    //gameWindow.webContents.openDevTools();

    gameWindow.on('closed', () => {
        gameWindow = null;
        if (process.platform == 'darwin') app.quit();
    });
};

const startAutoUpdater = (squirrelUrl) => {
    // The Squirrel application will watch the provided URL
    autoUpdater.setFeedURL(`${squirrelUrl}/win64/`);
  
    // Display a success message on successful update
    autoUpdater.addListener("update-downloaded", (event, releaseNotes, releaseName) => {
        dialog.showMessageBox({"message": `The release ${releaseName} has been downloaded`});
    });
  
    // Display an error message on update error
    autoUpdater.addListener("error", (error) => {
        dialog.showMessageBox({"message": "Auto updater error: " + error});
    });
  
    // tell squirrel to check for updates
    autoUpdater.checkForUpdates();
}

function setMainMenu()
{
    var template = [
        {
            label: 'Přítmí',
            submenu: [
                { label: 'Pokračovat', accelerator: 'CommandOrControl+C', click() { gameWindow.webContents.send('continue-game'); } },
                { label: 'Nová hra', accelerator: 'CommandOrControl+N', click() { gameWindow.webContents.send('new-game'); } },
                { type: 'separator' },
                { label: 'Nahrát hru', accelerator: 'CommandOrControl+O', click() { gameWindow.webContents.send('load-game'); } },
                { label: 'Uložit hru', accelerator: 'CommandOrControl+S', click() { gameWindow.webContents.send('save-game'); } },
                { type: 'separator' },
                { label: 'Nastavení', accelerator: 'CommandOrControl+G', click() { gameWindow.webContents.send('config-game'); } },
                { label: 'O hře', accelerator: 'CommandOrControl+H', role: 'about' },
                { type: 'separator' },
                { label: 'Konec', accelerator: 'CommandOrControl+Q', click() { app.quit(); } }
            ]
        },
    ];

    var menu = Menu.buildFromTemplate(template);
    Menu.setApplicationMenu(menu)
}

app.on('ready', createWindow);

/*app.on('ready', () => {
    if (process.platform == "win32") startAutoUpdater(updateUrl);
});*/

app.on('window-all-closed', () => {
    if (process.platform !== 'darwin') {
        app.quit();
    }
});

app.on('activate', () => {
    if (BrowserWindow.getAllWindows().length === 0) {
        createWindow();
    }
});

ipcMain.handle('is_fullscreen', async (event, arg) => {
    return gameWindow.isFullScreen();
});

ipcMain.handle('set_fullscreen', async (event, arg) => {
    return gameWindow.setFullScreen(arg);
});

ipcMain.handle('quit', async (event, arg) => {
    return app.quit();
});

ipcMain.handle('platform', async (event, arg) => {
    return process.platform;
});

